<?php

/**
 * Class that operate on table 'billsreturn'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-08-06 13:48
 */
class BillsreturnMySqlDAO implements BillsreturnDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BillsreturnMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM billsreturn WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM billsreturn';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM billsreturn ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param billsreturn primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM billsreturn WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BillsreturnMySql billsreturn
     */
    public function insert($billsreturn) {
        $sql = 'INSERT INTO billsreturn (billid, returnedprice, date, deleted , dailyentryid , userid, branchid , clientreceivevalue) VALUES (? ,? , ? ,? , ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($billsreturn->billid);
        $sqlQuery->set($billsreturn->returnedprice);
        $sqlQuery->set($billsreturn->date);
        $sqlQuery->setNumber($billsreturn->deleted);
        $sqlQuery->setNumber($billsreturn->dailyentryid);
        $sqlQuery->setNumber($billsreturn->userid);

        $sqlQuery->setNumber($billsreturn->branchid);
        $sqlQuery->setNumber($billsreturn->clientreceivevalue);

        $id = $this->executeInsert($sqlQuery);
        $billsreturn->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BillsreturnMySql billsreturn
     */
    public function update($billsreturn) {
        $sql = 'UPDATE billsreturn SET billid = ?, returnedprice = ?, date = ?, deleted = ? , dailyentryid = ? , userid = ? , branchid = ? , clientreceivevalue = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($billsreturn->billid);
        $sqlQuery->set($billsreturn->returnedprice);
        $sqlQuery->set($billsreturn->date);
        $sqlQuery->setNumber($billsreturn->deleted);
        $sqlQuery->setNumber($billsreturn->dailyentryid);
        $sqlQuery->setNumber($billsreturn->userid);

        $sqlQuery->setNumber($billsreturn->branchid);
        $sqlQuery->setNumber($billsreturn->clientreceivevalue);

        $sqlQuery->setNumber($billsreturn->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM billsreturn';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBillid($value) {
        $sql = 'SELECT * FROM billsreturn WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnedprice($value) {
        $sql = 'SELECT * FROM billsreturn WHERE returnedprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDate($value) {
        $sql = 'SELECT * FROM billsreturn WHERE date = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeleted($value) {
        $sql = 'SELECT * FROM billsreturn WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBillid($value) {
        $sql = 'DELETE FROM billsreturn WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnedprice($value) {
        $sql = 'DELETE FROM billsreturn WHERE returnedprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDate($value) {
        $sql = 'DELETE FROM billsreturn WHERE date = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeleted($value) {
        $sql = 'DELETE FROM billsreturn WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BillsreturnMySql
     */
    protected function readRow($row) {
        $billsreturn = new Billsreturn();

        $billsreturn->id = isset($row['id']) ? $row['id'] : '';
        $billsreturn->billid = isset($row['billid']) ? $row['billid'] : '';
        $billsreturn->returnedprice = isset($row['returnedprice']) ? $row['returnedprice'] : '';
        $billsreturn->date = isset($row['date']) ? $row['date'] : '';
        $billsreturn->deleted = isset($row['deleted']) ? $row['deleted'] : '';
        $billsreturn->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $billsreturn->userid = isset($row['userid']) ? $row['userid'] : '';
        $billsreturn->branchid = isset($row['branchid']) ? $row['branchid'] : '';
        $billsreturn->clientreceivevalue = isset($row['clientreceivevalue']) ? $row['clientreceivevalue'] : '';
        ##################################
        $billsreturn->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $billsreturn->username = isset($row['username']) ? $row['username'] : '';
        $billsreturn->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $billsreturn->billno = isset($row['billno']) ? $row['billno'] : '';
        $billsreturn->totaldiscount = isset($row['totaldiscount']) ? $row['totaldiscount'] : '';

        // m7md

        $billsreturn->sumBillReturnQuantity = isset($row['sumBillReturnQuantity']) ? $row['sumBillReturnQuantity'] : '';
        $billsreturn->productid = isset($row['productid']) ? $row['productid'] : '';
        $billsreturn->productprice = isset($row['productprice']) ? $row['productprice'] : '';
        $billsreturn->saveid = isset($row['saveid']) ? $row['saveid'] : '';



        return $billsreturn;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BillsreturnMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>